//###################################################################
//	Comm.cpp : Communication file
//
//	S_COM_RequestZoomFocus  : 
//	S_COM_AccessEEData()	: Access EEProm data
//	S_DomeCruise()			: Cam into cruise mode
//	S_COM_Manual()			: Cam into manual mode
//	S_COM_Left()			: Pan left
//	S_COM_Right()			: Pan right
//	S_COM_Up()				: Pan Up
//	S_COM_Down()			: Pan down
//	S_COM_PanStop()			: Pan stop
//	S_COM_TiltStop()		: Tilt stop
//	S_COM_PanTo()			: Pan to location
//	S_COM_TiltTo()			: Tilt to location
//	RequestDome()			:
//	ComRTSHiLow()			:
//	RTS_WriteFile()			:
//	RTS_WriteReadFile()		:
//	S_GetComm()				:
//###################################################################
#include "stdafx.h"
#include "SpeedDome.h"
#include "ControlDlg.h"
#include "mmsystem.h"
#include "misc.h"
#include "comm.h"
#include "time.h"
#include "define.h"
#include "GlobalVar.h"
#include "winbase.h"

//####################################################################
//	S_COM_ReadDomeType()
//####################################################################
void CComm::S_COM_ReadDomeType(	unsigned char DomeID,
								unsigned char *MotorType,
								unsigned char *CameraType )
{
DWORD			NumberOfBytesWritten,NumberOfBytesRead;
unsigned char	Buffer[6]={'\x0','\x0','\x0','\x0','\x0','\x0'};
char			Packet[6]={'\x0','\x0','\x2','\x0','\x0','\x0'};

//--- Read Motor Type ----------------------------------------
Packet[0]=(char)DomeID;
Packet[3]='\x0';				Packet[4]='\x0';
Packet[5]=(((Packet[0]^Packet[1])^Packet[2] )^Packet[3])^Packet[4];
RTS_WriteReadFile(hcom,Packet,6,&NumberOfBytesWritten,NULL,
				  Buffer,&NumberOfBytesRead,G_DelayTime);
//--- Motor Type in Buffer[3] -------------------------------------
*MotorType=Buffer[3];
*CameraType=Buffer[4];
}

//####################################################################
//	S_COM_AutoFlip()
//####################################################################
void CComm::S_COM_AutoFlip()
{
DWORD			NumberOfBytesWritten,NumberOfBytesRead;
unsigned char	Buffer[6]={'\x0','\x0','\x0','\x0','\x0','\x0'};
char			Packet[6]={'\x0','\x0','\x18','\x0','\x0','\x0'};

//--- Read AutoFlip ------------------------------------------
Packet[0]=(char)G_DomeID;
Packet[3]='\x05';				Packet[4]='\x0';
Packet[5]=(((Packet[0]^Packet[1])^Packet[2] )^Packet[3])^Packet[4];
RTS_WriteReadFile(hcom,Packet,6,&NumberOfBytesWritten,NULL,
				  Buffer,&NumberOfBytesRead,G_DelayTime);
//--- Set AutoFlip -------------------------------------------
Packet[0]=(char)G_DomeID;
Packet[3]='\x04';

if(Buffer[4]=='\x0')	
	Packet[4]='\x1';
else					
	Packet[4]='\x0';
Packet[5]=(((Packet[0]^Packet[1])^Packet[2] )^Packet[3])^Packet[4];
RTS_WriteReadFile(hcom,Packet,6,&NumberOfBytesWritten,NULL,
				  Buffer,&NumberOfBytesRead,G_DelayTime);

}

//####################################################################
//	S_COM_RequestZoomFocus()
//####################################################################
void CComm::S_COM_RequestZoomFocus(unsigned char *Zoom)
{
DWORD			NumberOfBytesWritten,NumberOfBytesRead;
unsigned char	Buffer[7]="\x00\x00\x00\x00\x00\x00";
char			R_Pkt[6]={'\x0','\x0','\x20','\x01','\x0','\x0'};
char			R_ReadPkt[6]={'\x0','\x0','\x2b','\x00','\x0','\x0'};

//---- Request Zoom camera status -----------------------------
R_Pkt[0]=(char)G_DomeID;
R_Pkt[5]=(((R_Pkt[0]^R_Pkt[1])^R_Pkt[2] )^R_Pkt[3])^R_Pkt[4];

RTS_WriteReadFile(hcom,R_Pkt,6,&NumberOfBytesWritten,NULL,
				  Buffer,&NumberOfBytesRead,G_DelayTime);
Sleep(50);
//---- Read Zoom Lens Response data ---------------------------
R_ReadPkt[0]=(char)G_DomeID;
R_ReadPkt[5]=(((R_ReadPkt[0]^R_ReadPkt[1])^R_ReadPkt[2] )^R_ReadPkt[3])^R_ReadPkt[4];

RTS_WriteReadFile(hcom,R_ReadPkt,6,&NumberOfBytesWritten,NULL,
				  Buffer,&NumberOfBytesRead,G_DelayTime);

Zoom[0]=Buffer[3];
Zoom[1]=Buffer[4];
}

//####################################################################
//	S_COM_OSD_VKey()
//####################################################################
void CComm::S_COM_OSD_VKey(UINT VKey)
{
DWORD			NumberOfBytesWritten,NumberOfBytesRead;
unsigned char	Buffer[6]={'\x0','\x0','\x0','\x0','\x0','\x0'};
char			Packet[6]={'\x0','\x0','\x28','\x0','\x0','\x0'};

//-----------------------------------------------
Packet[0]=(char)G_DomeID;
Packet[3]=VKey;			Packet[4]='\x0';

if ( VKey==5 )
	Packet[3]='\xff';

Packet[5]=(((Packet[0]^Packet[1])^Packet[2] )^Packet[3])^Packet[4];
RTS_WriteReadFile(hcom,Packet,6,&NumberOfBytesWritten,NULL,
				  Buffer,&NumberOfBytesRead,G_DelayTime);
}

//####################################################################
//	S_COM_AutoIRIS()
//####################################################################
void CComm::S_COM_AutoIRIS()
{
DWORD			NumberOfBytesWritten,NumberOfBytesRead;
unsigned char	Buffer[12]="\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";
char			Packet[6]={'\x0','\x0','\x23','\x0','\x0','\x0'};

//---- IRIS Open --------------------------------------------
Packet[0]=(char)G_DomeID;
Packet[3]='\x04';			Packet[4]='\x0';

Packet[5]=(((Packet[0]^Packet[1])^Packet[2] )^Packet[3])^Packet[4];
RTS_WriteReadFile(hcom,Packet,6,&NumberOfBytesWritten,NULL,
				  Buffer,&NumberOfBytesRead,G_DelayTime);
}

//####################################################################
//	S_COM_IRIS_Open()
//####################################################################
void CComm::S_COM_IRIS_Open()
{
DWORD			NumberOfBytesWritten,NumberOfBytesRead;
unsigned char	Buffer[12]="\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";
char			Packet[6]={'\x0','\x0','\x23','\x0','\x0','\x0'};

//---- IRIS Open --------------------------------------------
Packet[0]=(char)G_DomeID;
Packet[3]='\x02';			Packet[4]='\x0';

Packet[5]=(((Packet[0]^Packet[1])^Packet[2] )^Packet[3])^Packet[4];

RTS_WriteReadFile(hcom,Packet,6,&NumberOfBytesWritten,NULL,
				  Buffer,&NumberOfBytesRead,G_DelayTime);

}

//####################################################################
//	S_COM_IRIS_Close()
//####################################################################
void CComm::S_COM_IRIS_Close()
{
DWORD			NumberOfBytesWritten,NumberOfBytesRead;
unsigned char	Buffer[12]="\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";
char			Packet[6]={'\x0','\x0','\x23','\x0','\x0','\x0'};

//---- IRIS Open --------------------------------------------
Packet[0]=(char)G_DomeID;
Packet[3]='\x03';			Packet[4]='\x0';

Packet[5]=(((Packet[0]^Packet[1])^Packet[2] )^Packet[3])^Packet[4];

RTS_WriteReadFile(hcom,Packet,6,&NumberOfBytesWritten,NULL,
				  Buffer,&NumberOfBytesRead,G_DelayTime);

}

//####################################################################
//	S_COM_IRISTo()
//####################################################################
void CComm::S_COM_IRISTo(unsigned int Data )
{
DWORD			NumberOfBytesWritten,NumberOfBytesRead;
unsigned char	Buffer[12]="\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";
char			Packet[6]={'\x0','\x0','\x23','\x0','\x0','\x0'};

//---- IRIS to --------------------------------------------
Packet[0]=(char)G_DomeID;
Packet[3]='\x0';			Packet[4]=Data;

Packet[5]=(((Packet[0]^Packet[1])^Packet[2] )^Packet[3])^Packet[4];

RTS_WriteReadFile(hcom,Packet,6,&NumberOfBytesWritten,NULL,
				  Buffer,&NumberOfBytesRead,G_DelayTime);

}

//####################################################################
//	S_COM_IRISOpen()
//####################################################################
void CComm::S_COM_IRISOpen()
{
DWORD			NumberOfBytesWritten,NumberOfBytesRead;
unsigned char	Buffer[12]="\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";
char			Packet[6]={'\x0','\x0','\x23','\x02','\x0','\x0'};

//---- IRIS Open --------------------------------------------
Packet[0]=(char)G_DomeID;

Packet[5]=(((Packet[0]^Packet[1])^Packet[2] )^Packet[3])^Packet[4];

RTS_WriteReadFile(hcom,Packet,6,&NumberOfBytesWritten,NULL,
				  Buffer,&NumberOfBytesRead,G_DelayTime);
}

//####################################################################
//	S_COM_IRISClose()
//####################################################################
void CComm::S_COM_IRISClose()
{
DWORD			NumberOfBytesWritten,NumberOfBytesRead;
unsigned char	Buffer[12]="\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";
char			Packet[6]={'\x0','\x0','\x23','\x03','\x0','\x0'};

Packet[0]=(char)G_DomeID;

Packet[5]=(((Packet[0]^Packet[1])^Packet[2] )^Packet[3])^Packet[4];

RTS_WriteReadFile(hcom,Packet,6,&NumberOfBytesWritten,NULL,
				  Buffer,&NumberOfBytesRead,G_DelayTime);
}

//####################################################################
//	S_COM_IRISStop()
//####################################################################
void CComm::S_COM_IRISStop()
{
DWORD			NumberOfBytesWritten,NumberOfBytesRead;
unsigned char	Buffer[12]="\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";
char			Packet[6]={'\x0','\x0','\x23','\x05','\x0','\x0'};

Packet[0]=(char)G_DomeID;

Packet[5]=(((Packet[0]^Packet[1])^Packet[2] )^Packet[3])^Packet[4];

RTS_WriteReadFile(hcom,Packet,6,&NumberOfBytesWritten,NULL,
				  Buffer,&NumberOfBytesRead,G_DelayTime);
}

//####################################################################
//	S_COM_AutoFocus()
//####################################################################
void CComm::S_COM_AutoFocus(char Data)
{
DWORD			NumberOfBytesWritten,NumberOfBytesRead;
unsigned char	Buffer[12]="\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";
char			Packet[6]={'\x0','\x0','\x26','\x0','\x0','\x0'};

//---------- Focus to -------------------------------------
Packet[0]=(char)G_DomeID;	Packet[3]=Data;

Packet[5]=(((Packet[0]^Packet[1])^Packet[2] )^Packet[3])^Packet[4];

RTS_WriteReadFile(hcom,Packet,6,&NumberOfBytesWritten,NULL,
				  Buffer,&NumberOfBytesRead,G_DelayTime);

}

//####################################################################
//	S_COM_FocusSpeed()
//####################################################################
void CComm::S_COM_FocusSpeed(unsigned int FocusSpeed)
{
DWORD			NumberOfBytesWritten,NumberOfBytesRead;
unsigned char	Buffer[12]="\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";
char			SpeedPkt[6]={'\x0','\x0','\x25','\x03','\x0','\x0'};

//---- Set Focus speed ------------------------------------
if(FocusSpeed>0)
	FocusSpeed=3;
SpeedPkt[0]=(char)G_DomeID;		SpeedPkt[4]=FocusSpeed;
SpeedPkt[5]=(((SpeedPkt[0]^SpeedPkt[1])^SpeedPkt[2] )^SpeedPkt[3])^SpeedPkt[4];

RTS_WriteReadFile(hcom,SpeedPkt,6,&NumberOfBytesWritten,NULL,
				  Buffer,&NumberOfBytesRead,G_DelayTime);
}

//####################################################################
//	S_COM_FocusTo()
//####################################################################
void CComm::S_COM_FocusTo(unsigned int Data)
{
DWORD			NumberOfBytesWritten,NumberOfBytesRead;
unsigned char	Buffer[12]="\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";
char			Packet[6]={'\x0','\x0','\x25','\x0','\x0','\x0'};

//---------- Focus to -------------------------------------
Packet[0]=(char)G_DomeID;
Packet[3]='\x02';			Packet[4]=Data;

Packet[5]=(((Packet[0]^Packet[1])^Packet[2] )^Packet[3])^Packet[4];

RTS_WriteReadFile(hcom,Packet,6,&NumberOfBytesWritten,NULL,
				  Buffer,&NumberOfBytesRead,G_DelayTime);
}

//####################################################################
//	S_COM_FocusIn()
//####################################################################
void CComm::S_COM_FocusIn()
{
DWORD			NumberOfBytesWritten,NumberOfBytesRead;
unsigned char	Buffer[12]="\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";
char			Packet[6]={'\x0','\x0','\x25','\x0','\x0','\x0'};

//---------- Focus to -------------------------------------
Packet[0]=(char)G_DomeID;
Packet[5]=(((Packet[0]^Packet[1])^Packet[2] )^Packet[3])^Packet[4];

RTS_WriteReadFile(hcom,Packet,6,&NumberOfBytesWritten,NULL,
				  Buffer,&NumberOfBytesRead,G_DelayTime);
}

//####################################################################
//	S_COM_FocusOut()
//####################################################################
void CComm::S_COM_FocusOut()
{
DWORD			NumberOfBytesWritten,NumberOfBytesRead;
unsigned char	Buffer[12]="\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";
char			Packet[6]={'\x0','\x0','\x25','\x01','\x0','\x0'};

//---------- Focus to -------------------------------------
Packet[0]=(char)G_DomeID;
Packet[5]=(((Packet[0]^Packet[1])^Packet[2] )^Packet[3])^Packet[4];

RTS_WriteReadFile(hcom,Packet,6,&NumberOfBytesWritten,NULL,
				  Buffer,&NumberOfBytesRead,G_DelayTime);
}

//####################################################################
//	S_COM_FocusStop()
//####################################################################
void CComm::S_COM_FocusStop()
{
DWORD			NumberOfBytesWritten,NumberOfBytesRead;
unsigned char	Buffer[12]="\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";
char			Packet[6]={'\x0','\x0','\x25','\x0','\x0','\x0'};

Packet[0]=(char)G_DomeID;
Packet[3]='\x04';			Packet[4]='\x00'; 
Packet[5]=(((Packet[0]^Packet[1])^Packet[2] )^Packet[3])^Packet[4];

RTS_WriteReadFile(hcom,Packet,6,&NumberOfBytesWritten,NULL,
			 Buffer,&NumberOfBytesRead,G_DelayTime );

}

//####################################################################
//	S_COM_ZoomSpeed()
//####################################################################
void CComm::S_COM_ZoomSpeed(unsigned int ZoomSpeed)
{
DWORD			NumberOfBytesWritten,NumberOfBytesRead;
unsigned char	Buffer[12]="\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";
char			SpeedPkt[6]={'\x0','\x0','\x24','\x03','\x0','\x0'};

//---- Set Zoom speed ------------------------------------
if(ZoomSpeed>0)
	ZoomSpeed=3;
SpeedPkt[0]=(char)G_DomeID;		SpeedPkt[4]=ZoomSpeed;
SpeedPkt[5]=(((SpeedPkt[0]^SpeedPkt[1])^SpeedPkt[2] )^SpeedPkt[3])^SpeedPkt[4];

RTS_WriteReadFile(hcom,SpeedPkt,6,&NumberOfBytesWritten,NULL,
				  Buffer,&NumberOfBytesRead,G_DelayTime);
}

//####################################################################
//	S_COM_ZoomTo()
//####################################################################
void CComm::S_COM_ZoomTo(unsigned int Data )
{
DWORD			NumberOfBytesWritten,NumberOfBytesRead;
unsigned char	Buffer[12]="\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";
char			Packet[6]={'\x0','\x0','\x24','\x02','\x0','\x0'};

//---- Zoom to --------------------------------------------
Packet[0]=(char)G_DomeID;
Packet[3]='\x02';			Packet[4]=Data;

Packet[5]=(((Packet[0]^Packet[1])^Packet[2] )^Packet[3])^Packet[4];

RTS_WriteReadFile(hcom,Packet,6,&NumberOfBytesWritten,NULL,
				  Buffer,&NumberOfBytesRead,G_DelayTime);

}

//####################################################################
//	S_COM_ZoomIn()
//####################################################################
void CComm::S_COM_ZoomIn()
{
DWORD			NumberOfBytesWritten,NumberOfBytesRead;
unsigned char	Buffer[12]="\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";
char			Packet[6]={'\x0','\x0','\x24','\x01','\x0','\x0'};

//---- Zoom to --------------------------------------------
Packet[0]=(char)G_DomeID;

Packet[5]=(((Packet[0]^Packet[1])^Packet[2] )^Packet[3])^Packet[4];

RTS_WriteReadFile(hcom,Packet,6,&NumberOfBytesWritten,NULL,
				  Buffer,&NumberOfBytesRead,G_DelayTime);

}
//####################################################################
//	S_COM_ZoomOut()
//####################################################################
void CComm::S_COM_ZoomOut()
{
DWORD			NumberOfBytesWritten,NumberOfBytesRead;
unsigned char	Buffer[12]="\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";
char			Packet[6]={'\x0','\x0','\x24','\x00','\x0','\x0'};

//---- Zoom to --------------------------------------------
Packet[0]=(char)G_DomeID;

Packet[5]=(((Packet[0]^Packet[1])^Packet[2] )^Packet[3])^Packet[4];

RTS_WriteReadFile(hcom,Packet,6,&NumberOfBytesWritten,NULL,
				  Buffer,&NumberOfBytesRead,G_DelayTime);

}

//####################################################################
//	S_COM_ZoomStop()
//####################################################################
void CComm::S_COM_ZoomStop()
{
DWORD			NumberOfBytesWritten,NumberOfBytesRead;
unsigned char	Buffer[12]="\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";
char			Packet[6]={'\x0','\x0','\x24','\x0','\x0','\x0'};

Packet[0]=(char)G_DomeID;
Packet[3]='\x04';
Packet[5]=(((Packet[0]^Packet[1])^Packet[2] )^Packet[3])^Packet[4];

RTS_WriteReadFile(hcom,Packet,6,&NumberOfBytesWritten,NULL,
			 Buffer,&NumberOfBytesRead,G_DelayTime );

}

//####################################################################
//	S_COM_AccessEEData()
//		EEAddr = Address (L,H)
//		String = Time	Pan		Tilt	Zoom	PanSpeed	TiltSpeed
//				 2		2		2		1		1			1
//####################################################################
void CComm::S_COM_AccessEEData(int RW,char *EEAddr,
						int BytesToAccess,char *String)
{
DWORD	NumberOfBytesWritten,NumberOfBytesRead;
char	Buffer[6]={'\x0','\x0','\x0','\x0','\x0','\x0'};
char	PEEAddr[6]={'\x0','\x0','\x03','\x0','\x0','\x0'};
char	PEEData[6]={'\x0','\x0','\x04','\x0','\x0','\x0'};
int		i;
char	*ptr;

ptr=String;

PEEAddr[0]=(char)G_DomeID;
PEEData[0]=(char)G_DomeID;
//---- Input EEprom address --------
PEEAddr[3]=EEAddr[0];	PEEAddr[4]=EEAddr[1];
PEEAddr[5]=(((PEEAddr[0]^PEEAddr[1])^PEEAddr[2] )^PEEAddr[3])^PEEAddr[4];

//---- Disable Timer
Flag_Polling=0;

//---- Set Address -----------------
RTS_WriteReadFile(hcom,PEEAddr,6,&NumberOfBytesWritten,NULL,
				 PEEAddr,&NumberOfBytesRead,G_DelayTime);

if( RW==0) //---- Write EE
	{	
	PEEData[3]='\x0';
	for( i=0; i<=(BytesToAccess-1) ;i++ )
		{
		//---- Write data to EE
		PEEData[4]=*ptr;
		PEEData[5]=(((PEEData[0]^PEEData[1])^PEEData[2] )^PEEData[3])^PEEData[4];

		RTS_WriteReadFile(hcom,PEEData,6,&NumberOfBytesWritten,NULL,
							Buffer,&NumberOfBytesRead,G_DelayTime);
		ptr=ptr++;
		Sleep(20);
		}
	}
else		//---- Read EE
	{
	PEEData[3]='\x1';
	for( i=0; i<=(BytesToAccess-1) ;i++ )
		{
		//---- Read data from EE
		PEEData[4]='\x0';
		PEEData[5]=(((PEEData[0]^PEEData[1])^PEEData[2] )^PEEData[3])^PEEData[4];

		RTS_WriteReadFile(hcom,PEEData,6,&NumberOfBytesWritten,NULL,
							Buffer,&NumberOfBytesRead,G_DelayTime);
		Sleep(15);
		*ptr=Buffer[4];
		ptr=ptr++;
		}
	}


//---- Enable Timer
Flag_Polling=1;

}


//####################################################################
//	S_DomeCruise()
//####################################################################
void CComm::S_COM_Cruise()
{
DWORD			NumberOfBytesWritten;
DWORD			NumberOfBytesRead;
unsigned char	Buffer[12]="\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";
char			Packet[6]={'\x0','\x0','\x11','\x02','\x0','\x0'};

Packet[0]=(char)G_DomeID;
Packet[5]=(((Packet[0]^Packet[1])^Packet[2] )^Packet[3])^Packet[4];

RTS_WriteReadFile(hcom,Packet,6,&NumberOfBytesWritten,NULL,
					Buffer,&NumberOfBytesRead,G_DelayTime);

}


//####################################################################
//	S_COM_Manual()
//####################################################################
void CComm::S_COM_Manual()
{
DWORD			NumberOfBytesWritten;
DWORD			NumberOfBytesRead;
unsigned char	Buffer[12]="\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";
char			Packet[6]={'\x0','\x0','\x12','\x0','\x0','\x0'};

Packet[0]=(char)G_DomeID;
Packet[5]=(((Packet[0]^Packet[1])^Packet[2] )^Packet[3])^Packet[4];

RTS_WriteReadFile(hcom,Packet,6,&NumberOfBytesWritten,NULL,
				  Buffer,&NumberOfBytesRead,G_DelayTime);

}


//####################################################################
//	S_COM_Left()
//####################################################################
void CComm::S_COM_Left(int PanSpeed)
{

DWORD			NumberOfBytesWritten,NumberOfBytesRead;
unsigned char	Buffer[12]="\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";
char			Packet[6]={'\x0','\x0','\x18','\x01','\x0','\x0'};

//---- Pan Left -----
Packet[0]=(char)G_DomeID;	Packet[4]=PanSpeed;
Packet[5]=(((Packet[0]^Packet[1])^Packet[2] )^Packet[3])^Packet[4];

RTS_WriteReadFile(hcom,Packet,6,&NumberOfBytesWritten,NULL,
					Buffer,&NumberOfBytesRead,G_DelayTime);

}


//####################################################################
//	S_COM_Right()
//####################################################################
void CComm::S_COM_Right(int PanSpeed)
{
DWORD			NumberOfBytesWritten,NumberOfBytesRead;
unsigned char	Buffer[12]="\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";
char			Packet[6]={'\x0','\x0','\x18','\x00','\x0','\x0'};

//---- Pan Right ------
Packet[0]=(char)G_DomeID;		Packet[4]=PanSpeed;
Packet[5]=(((Packet[0]^Packet[1])^Packet[2] )^Packet[3])^Packet[4];

RTS_WriteReadFile(hcom,Packet,6,&NumberOfBytesWritten,NULL,
				Buffer,&NumberOfBytesRead,G_DelayTime);

}


//####################################################################
//	S_COM_Up()
//####################################################################
void CComm::S_COM_Up(int TiltSpeed)
{

DWORD			NumberOfBytesWritten,NumberOfBytesRead;
unsigned char	Buffer[12]="\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";
char			Packet[6]={'\x0','\x0','\x18','\x02','\x0','\x0'};

//---- Set Tilt Location
Packet[0]=(char)G_DomeID;  Packet[4]=TiltSpeed;
Packet[5]=(((Packet[0]^Packet[1])^Packet[2] )^Packet[3])^Packet[4];

RTS_WriteReadFile(hcom,Packet,6,&NumberOfBytesWritten,NULL,
				  Buffer,&NumberOfBytesRead,G_DelayTime);

}


//####################################################################
//	S_COM_Down()
//####################################################################
void CComm::S_COM_Down(int TiltSpeed)
{

DWORD			NumberOfBytesWritten,NumberOfBytesRead;
unsigned char	Buffer[12]="\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";
char			Packet[6]={'\x0','\x0','\x18','\x03','\x0','\x0'};

//---- Set Tilt Location ----
Packet[0]=(char)G_DomeID;   Packet[4]=TiltSpeed;
Packet[5]=(((Packet[0]^Packet[1])^Packet[2] )^Packet[3])^Packet[4];

CComm::RTS_WriteReadFile(hcom,Packet,6,&NumberOfBytesWritten,NULL,
				  Buffer,&NumberOfBytesRead,G_DelayTime);

}


//####################################################################
//	S_COM_PanStop()
//####################################################################
void CComm::S_COM_PanStop()
{
DWORD			NumberOfBytesWritten,NumberOfBytesRead;
unsigned char	Buffer[12]="\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";
char			Packet[6]={'\x0','\x0','\x13','\x0','\x0','\x0'};

Packet[0]=(char)G_DomeID;
Packet[5]=(((Packet[0]^Packet[1])^Packet[2] )^Packet[3])^Packet[4];

RTS_WriteReadFile(hcom,Packet,6,&NumberOfBytesWritten,NULL,
			 Buffer,&NumberOfBytesRead,G_DelayTime );

}


//####################################################################
//	S_COM_TiltStop()
//####################################################################
void CComm::S_COM_TiltStop()
{

DWORD			NumberOfBytesWritten,NumberOfBytesRead;
unsigned char	Buffer[12]="\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";
char			Packet[6]={'\x0','\x0','\x14','\x0','\x0','\x0'};

Packet[0]=(char)G_DomeID;
Packet[5]=(((Packet[0]^Packet[1])^Packet[2] )^Packet[3])^Packet[4];

RTS_WriteReadFile(hcom,Packet,6,&NumberOfBytesWritten,NULL,
				  Buffer,&NumberOfBytesRead,G_DelayTime);

}


//####################################################################
//	S_COM_PanTo()
//####################################################################
void CComm::S_COM_PanTo(unsigned int LData,unsigned int HData)
{
DWORD			NumberOfBytesWritten,NumberOfBytesRead;
unsigned char	Buffer[12]="\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";
char			Packet[6]={'\x0','\x0','\x07','\x0','\x0','\x0'};

Packet[0]=(char)G_DomeID;
Packet[3]=LData;	Packet[4]=HData;

Packet[5]=(((Packet[0]^Packet[1])^Packet[2] )^Packet[3])^Packet[4];

RTS_WriteReadFile(hcom,Packet,6,&NumberOfBytesWritten,NULL,
				  Buffer,&NumberOfBytesRead,G_DelayTime);

}


//####################################################################
//	S_COM_TiltTo()
//####################################################################
void CComm::S_COM_TiltTo(unsigned int LData,unsigned int HData)
{
DWORD			NumberOfBytesWritten,NumberOfBytesRead;
unsigned char	Buffer[12]="\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";
char			Packet[6]={'\x0','\x0','\x08','\x0','\x0','\x0'};

Packet[0]=(char)G_DomeID;
Packet[3]=LData;	Packet[4]=HData;

Packet[5]=(((Packet[0]^Packet[1])^Packet[2] )^Packet[3])^Packet[4];

RTS_WriteReadFile(hcom,Packet,6,&NumberOfBytesWritten,NULL,
				  Buffer,&NumberOfBytesRead,G_DelayTime);

}

//####################################################################
//	S_COM_PanSpeed()
//####################################################################
void CComm::S_COM_PanSpeed(unsigned int Speed)
{
DWORD			NumberOfBytesWritten,NumberOfBytesRead;
unsigned char	Buffer[12]="\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";
char			Packet[6]={'\x0','\x0','\x0b','\x0','\x0','\x0'};

Packet[0]=(char)G_DomeID;
Packet[3]=Speed;	Packet[4]=0;

Packet[5]=(((Packet[0]^Packet[1])^Packet[2] )^Packet[3])^Packet[4];

RTS_WriteReadFile(hcom,Packet,6,&NumberOfBytesWritten,NULL,
				  Buffer,&NumberOfBytesRead,G_DelayTime);
}

//####################################################################
//	S_COM_TiltSpeed()
//####################################################################
void CComm::S_COM_TiltSpeed(unsigned int Speed)
{
DWORD			NumberOfBytesWritten,NumberOfBytesRead;
unsigned char	Buffer[12]="\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";
char			Packet[6]={'\x0','\x0','\x0c','\x0','\x0','\x0'};

Packet[0]=(char)G_DomeID;
Packet[3]=Speed;	Packet[4]=0;

Packet[5]=(((Packet[0]^Packet[1])^Packet[2] )^Packet[3])^Packet[4];

RTS_WriteReadFile(hcom,Packet,6,&NumberOfBytesWritten,NULL,
				  Buffer,&NumberOfBytesRead,G_DelayTime);
}


//###############################################################
// 
// RequestDome()	:
//
//###############################################################
void CComm::RequestDome(char *Para) 
{
//----------------------------------------------------------------
DWORD	NumberOfBytesWritten,NumberOfBytesRead;
char	Buffer[7]={'\x0','\x0','\x0','\x0','\x0','\x0','\x0'};
char	R_PanPkt[6]={'\x0','\x0','\x09','\x0','\x0','\x0'};
char	R_TiltPkt[6]={'\x0','\x0','\x0a','\x0','\x0','\x0'};
char	R_ZoomFocusPkt[6]={'\x0','\x0','\x20','\x01','\x0','\x0'};
char	R_RPkt[6]={'\x0','\x0','\x2b','\x0','\x0','\x0'};


R_PanPkt[0]=(char)G_DomeID;
R_TiltPkt[0]=(char)G_DomeID;
R_ZoomFocusPkt[0]=(char)G_DomeID;
R_RPkt[0]=(char)G_DomeID;

R_PanPkt[5]=(((R_PanPkt[0]^R_PanPkt[1])^R_PanPkt[2] )^R_PanPkt[3])^R_PanPkt[4];
R_TiltPkt[5]=(((R_TiltPkt[0]^R_TiltPkt[1])^R_TiltPkt[2] )^R_TiltPkt[3])^R_TiltPkt[4];
R_ZoomFocusPkt[5]=(((R_ZoomFocusPkt[0]^R_ZoomFocusPkt[1])^R_ZoomFocusPkt[2] )^R_ZoomFocusPkt[3])^R_ZoomFocusPkt[4];
R_RPkt[5]=(((R_RPkt[0]^R_RPkt[1])^R_RPkt[2] )^R_RPkt[3])^R_RPkt[4];
//---- Request Pan location ----------------------------------------
RTS_WriteReadFile(hcom,R_PanPkt,6,&NumberOfBytesWritten,NULL,
				  Buffer,&NumberOfBytesRead,G_DelayTime);
Para[0]=Buffer[3];		Para[1]=Buffer[4];
//---- Request Tilt location ---------------------------------------
RTS_WriteReadFile(hcom,R_TiltPkt,6,&NumberOfBytesWritten,NULL,
				Buffer,&NumberOfBytesRead ,G_DelayTime);
Para[2]=Buffer[3];		Para[3]=Buffer[4];
//---- Request Zoom location ---------------------------------------
	CComm::RTS_WriteReadFile(hcom,R_ZoomFocusPkt,6,&NumberOfBytesWritten,NULL,
				  Buffer,&NumberOfBytesRead,G_DelayTime);

	CComm::RTS_WriteReadFile(hcom,R_RPkt,6,&NumberOfBytesWritten,NULL,
				  Buffer,&NumberOfBytesRead,G_DelayTime);
	Para[4]=Buffer[3];
}


//###############################################################
// 
// ResetDome()	:
//
//###############################################################
void CComm::ResetDome() 
{
//----------------------------------------------------------------
DWORD	NumberOfBytesWritten;
char	Buffer[7]={'\x0','\x0','\x0','\x0','\x0','\x0','\x0'};
char	Pkt[6]={'\x0','\x0','\x15','\xaa','\x55','\x0'};

Pkt[0]=(char)G_DomeID;
Pkt[5]=(((Pkt[0]^Pkt[1])^Pkt[2] )^Pkt[3])^Pkt[4];

//---- Reset Dome ----------------------------------------
//RTS_WriteReadFile(hcom,Pkt,6,&NumberOfBytesWritten,NULL,
//				  Buffer,&NumberOfBytesRead);

Flag_Polling=0;
Sleep(500);		//-- For firmware bug
RTS_WriteFile(hcom,Pkt,6,&NumberOfBytesWritten,NULL,G_DelayTime);
Sleep(500);		//-- For firmware bug
Flag_Polling=1;
}

//###############################################################
// 
// RequestAttitude()	:
//
//###############################################################
int CComm::RequestAttitude(char *Para) 
{
//----------------------------------------------------------------
DWORD	NumberOfBytesWritten,NumberOfBytesRead;
char	Buffer[7]={'\x0','\x0','\x0','\x0','\x0','\x0','\x0'};
char	R_PanPkt[6]={'\x0','\x0','\x09','\x0','\x0','\x0'};
char	R_TiltPkt[6]={'\x0','\x0','\x0a','\x0','\x0','\x0'};

R_PanPkt[0]=(char)G_DomeID;
R_TiltPkt[0]=(char)G_DomeID;

R_PanPkt[5]=(((R_PanPkt[0]^R_PanPkt[1])^R_PanPkt[2] )^R_PanPkt[3])^R_PanPkt[4];
R_TiltPkt[5]=(((R_TiltPkt[0]^R_TiltPkt[1])^R_TiltPkt[2] )^R_TiltPkt[3])^R_TiltPkt[4];

//---- Request Pan location ----------------------------------------
RTS_WriteReadFile(hcom,R_PanPkt,6,&NumberOfBytesWritten,NULL,
			  Buffer,&NumberOfBytesRead,G_TimerDelayTime);
Para[0]=Buffer[3];		Para[1]=Buffer[4];
//---- Request Tilt location ---------------------------------------
RTS_WriteReadFile(hcom,R_TiltPkt,6,&NumberOfBytesWritten,NULL,
		Buffer,&NumberOfBytesRead,G_TimerDelayTime );
Para[2]=Buffer[3];		Para[3]=Buffer[4];

if(Buffer[2]=='\x0a')	
	return 1;
else 
	return 0;

}


//#################################################################
//
//	RTS_WriteFile()
//
//#################################################################
BOOL CComm::RTS_WriteFile( HANDLE hFile,LPCVOID lpBuffer, DWORD nNumberOfBytesToWrite,
					LPDWORD lpNumberOfBytesWritten,LPOVERLAPPED lpOverlapped,int DelayTime)
{
BOOL		nCode;
DWORD		NumberOfBytesTransferred=0;
DWORD		dwBytesRet;
DWORD		EvtMask=EV_TXEMPTY;

if(RTS==1)
	{
	::EscapeCommFunction(hFile,SETRTS);

	::SetCommMask( hFile,EvtMask);
	//--- You needn't adjust RTS line for ADLINK converter -------
	nCode=::WriteFile(hFile,lpBuffer,nNumberOfBytesToWrite,
			  &NumberOfBytesTransferred,NULL) ;
	//------------------------------------------------------------
	::WaitCommEvent(hFile,&EvtMask,NULL);
	Sleep(1);

	::EscapeCommFunction(hFile,CLRRTS);
	}
else
	{
	//--- You needn't adjust RTS line for ADLINK converter -------
	nCode=::WriteFile(hFile,lpBuffer,nNumberOfBytesToWrite,
			&NumberOfBytesTransferred,NULL) ;
	//------------------------------------------------------------
	}
return nCode;

}

//#################################################################
//
//	RTS_WriteReadFile()
//
//#################################################################
void CComm::RTS_WriteReadFile(HANDLE hFile,LPVOID lpBuffer, DWORD nNumberOfBytesToWrite,
					LPDWORD lpNumberOfBytesWritten,LPOVERLAPPED lpOverlapped,
					LPVOID lpBufferR,LPDWORD lpNumberOfBytesRead,int DelayTime)

{
char*	ptrR;
char*	ptrS;
char	CheckSum;
int		Fail=0;
int		Retry=2;

Flag_Polling=0;	//-- Clear Polling Flag
Flag_Control=1;

do	{
		RTS_WriteFile(hFile,lpBuffer,nNumberOfBytesToWrite,lpNumberOfBytesWritten,lpOverlapped,DelayTime) ;
		::ReadFile(hFile,lpBufferR,nNumberOfBytesToWrite,lpNumberOfBytesRead,lpOverlapped);
		//--- Verify receive checksum
		ptrS=(char*) lpBuffer;
		ptrR=(char*) lpBufferR;
		CheckSum=(((ptrR[0]^ptrR[1])^ptrR[2] )^ptrR[3])^ptrR[4];
		if( ptrS[2]=='\x2b' )
			ptrS[2]='\x20';
		if ( (ptrR[5]==CheckSum)&&(ptrR[2]==ptrS[2]) )
			Fail=0;
		else
			{
			Sleep(20);		//-- Sleep for EEProm adjust RTS line
			Fail=1;
			}
		Retry=Retry-1;
	}
while( Fail && Retry);

Flag_Control=0;
Flag_Polling=1;	//-- Set Polling Flag

}


//######################################################################
//
// S_GetSetting()
//
//######################################################################

void CComm::S_GetSetting(char *string,unsigned int *AVL_NUM_DOME,int *m_RTS)
{
FILE	*fstream;
char 	*Fptr;
char	Temp1[30];
char	Temp2[30];
char	Temp3[30];
char	LineBuffer[100];
char	RS232_485[30]={NULL};


if( (fstream = fopen( "SpeedDome.ini", "r" )) != NULL )
	{
	//--- Scan COM setting ---
	if( fgets( LineBuffer, 80, fstream ) == NULL)		
		AfxMessageBox("Read Communication Port Setting Error\n");
	else						
		sscanf(LineBuffer,"%s = %s",Temp1,string);
	//--- Scan Devices setting ---
	if( fgets( LineBuffer, 80, fstream ) == NULL)		
		AfxMessageBox("Read Devices Number Error\n");
	else						
		sscanf(LineBuffer,"%s = %u ",Temp2,AVL_NUM_DOME);
	//--- Scan RS232-485 setting ---
	if( fgets( LineBuffer, 80, fstream ) == NULL)		
		AfxMessageBox("Read RS232-485 Setting Error\n");
	else						
		sscanf(LineBuffer,"%s = %s ",Temp3,RS232_485);
	fclose( fstream );
	}
if( strcmp(RS232_485,"RTS")==0 )
	*m_RTS=1;
else
	{
	if( strcmp(RS232_485,"AUTO")==0 )
		*m_RTS=0;
	else
		*m_RTS=-1;
	}
   
}


//####################################################################
//	S_COM_FillPresetMaxSpeedToEE()
//####################################################################
void CComm::S_COM_FillPresetMaxSpeedToEE(char MaxSpeed)
{
char			TempMaxSpeed[2]="\x08";
char			EEAddr[3];
WORD			Y_Addr;

Y_Addr=0x70d;

EEAddr[0]=LOBYTE(Y_Addr);
EEAddr[1]=HIBYTE(Y_Addr);

TempMaxSpeed[0]=MaxSpeed;
CComm::S_COM_AccessEEData(0,EEAddr,1,TempMaxSpeed);  //-- Get Preset parameter
TempMaxSpeed[0]='\x0';
CComm::S_COM_AccessEEData(1,EEAddr,1,TempMaxSpeed);  //-- Get Preset parameter

}

